/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.mocha.lexer.MolangLexer;
import team.unnamed.mocha.lexer.Token;
import team.unnamed.mocha.lexer.TokenKind;
import team.unnamed.mocha.parser.MolangParser;
import team.unnamed.mocha.parser.ParseException;
import team.unnamed.mocha.parser.ast.AccessExpression;
import team.unnamed.mocha.parser.ast.ArrayAccessExpression;
import team.unnamed.mocha.parser.ast.BinaryExpression;
import team.unnamed.mocha.parser.ast.CallExpression;
import team.unnamed.mocha.parser.ast.ExecutionScopeExpression;
import team.unnamed.mocha.parser.ast.Expression;
import team.unnamed.mocha.parser.ast.FloatExpression;
import team.unnamed.mocha.parser.ast.IdentifierExpression;
import team.unnamed.mocha.parser.ast.StatementExpression;
import team.unnamed.mocha.parser.ast.StringExpression;
import team.unnamed.mocha.parser.ast.TernaryConditionalExpression;
import team.unnamed.mocha.parser.ast.UnaryExpression;

final class MolangParserImpl
implements MolangParser {
    private static final Object UNSET_FLAG = new Object();
    private final MolangLexer lexer;
    @Nullable
    private Object current = UNSET_FLAG;

    MolangParserImpl(@NotNull MolangLexer lexer) {
        this.lexer = Objects.requireNonNull(lexer, "lexer");
    }

    @Nullable
    static Expression parseSingle(@NotNull MolangLexer lexer) throws IOException {
        Token token = lexer.current();
        switch (token.kind()) {
            case FLOAT: {
                lexer.next();
                String tokenValue = token.value();
                if (tokenValue == null) {
                    return null;
                }
                return FloatExpression.of(Float.parseFloat(tokenValue));
            }
            case STRING: {
                lexer.next();
                String tvalue = token.value();
                if (tvalue == null) {
                    return null;
                }
                return new StringExpression(tvalue);
            }
            case TRUE: {
                lexer.next();
                return FloatExpression.ONE;
            }
            case FALSE: {
                lexer.next();
                return FloatExpression.ZERO;
            }
            case LPAREN: {
                lexer.next();
                Expression expression = MolangParserImpl.parseCompoundExpression(lexer, 0);
                token = lexer.current();
                if (token.kind() != TokenKind.RPAREN) {
                    throw new ParseException("Non closed expression", lexer.cursor());
                }
                lexer.next();
                return expression;
            }
            case LBRACE: {
                lexer.next();
                ArrayList<Expression> expressions = new ArrayList<Expression>();
                while (true) {
                    Expression compoundExpression;
                    if ((compoundExpression = MolangParserImpl.parseCompoundExpression(lexer, 0)) != null) {
                        expressions.add(compoundExpression);
                    }
                    if ((token = lexer.current()).kind() == TokenKind.RBRACE) break;
                    if (token.kind() == TokenKind.EOF) {
                        throw new ParseException("Found the end before the execution scope closing token", lexer.cursor());
                    }
                    if (token.kind() == TokenKind.ERROR) {
                        throw new ParseException("Found an invalid token (error): " + token.value(), lexer.cursor());
                    }
                    if (token.kind() != TokenKind.SEMICOLON) {
                        throw new ParseException("Missing semicolon", lexer.cursor());
                    }
                    lexer.next();
                }
                lexer.next();
                return new ExecutionScopeExpression(expressions);
            }
            case BREAK: {
                lexer.next();
                return new StatementExpression(StatementExpression.Op.BREAK);
            }
            case CONTINUE: {
                lexer.next();
                return new StatementExpression(StatementExpression.Op.CONTINUE);
            }
            case IDENTIFIER: {
                String tovalue = token.value();
                if (tovalue == null) {
                    return null;
                }
                Expression expr = new IdentifierExpression(tovalue);
                token = lexer.next();
                while (token.kind() == TokenKind.DOT) {
                    token = lexer.next();
                    if (token.kind() != TokenKind.IDENTIFIER) {
                        throw new ParseException("Unexpected token, expected a valid field token", lexer.cursor());
                    }
                    String tokvalue = token.value();
                    if (tokvalue != null) {
                        expr = new AccessExpression(expr, tokvalue);
                    }
                    token = lexer.next();
                }
                return expr;
            }
            case SUB: {
                lexer.next();
                Expression operatedExpression = MolangParserImpl.parseSingle(lexer);
                if (operatedExpression instanceof FloatExpression) {
                    return FloatExpression.of(-((FloatExpression)operatedExpression).value());
                }
                if (operatedExpression != null) {
                    return new UnaryExpression(UnaryExpression.Op.ARITHMETICAL_NEGATION, operatedExpression);
                }
            }
            case BANG: {
                lexer.next();
                Expression unaryExpr = MolangParserImpl.parseSingle(lexer);
                if (unaryExpr == null) {
                    return null;
                }
                return new UnaryExpression(UnaryExpression.Op.LOGICAL_NEGATION, unaryExpr);
            }
            case RETURN: {
                lexer.next();
                Expression compoundExpression = MolangParserImpl.parseCompoundExpression(lexer, 0);
                if (compoundExpression == null) {
                    return null;
                }
                return new UnaryExpression(UnaryExpression.Op.RETURN, compoundExpression);
            }
        }
        return null;
    }

    @Nullable
    static Expression parseCompoundExpression(@NotNull MolangLexer lexer, int lastPrecedence) throws IOException {
        Expression expr = MolangParserImpl.parseSingle(lexer);
        if (expr == null) {
            return null;
        }
        while (true) {
            Expression compoundExpr = MolangParserImpl.parseCompound(lexer, expr, lastPrecedence);
            Token current = lexer.current();
            if (current.kind() == TokenKind.EOF || current.kind() == TokenKind.SEMICOLON) {
                return compoundExpr;
            }
            if (compoundExpr == expr) {
                return expr;
            }
            expr = compoundExpr;
        }
    }

    @Nullable
    static Expression parseCompound(@NotNull MolangLexer lexer, @Nullable Expression left, int lastPrecedence) throws IOException {
        BinaryExpression.Op op;
        Token current = lexer.current();
        switch (current.kind()) {
            case RPAREN: 
            case EOF: {
                return left;
            }
            case LBRACKET: {
                current = lexer.next();
                if (current.kind() == TokenKind.RBRACKET) {
                    throw new ParseException("Expected a expression, got RBRACKET", lexer.cursor());
                }
                if (current.kind() == TokenKind.EOF) {
                    throw new ParseException("Found EOF before closing RBRACKET", lexer.cursor());
                }
                Expression index = MolangParserImpl.parseCompoundExpression(lexer, 0);
                current = lexer.current();
                if (current.kind() == TokenKind.EOF) {
                    throw new ParseException("Found EOF before closing RBRACKET", lexer.cursor());
                }
                if (current.kind() != TokenKind.RBRACKET) {
                    throw new ParseException("Expected a closing RBRACKET, found " + String.valueOf(current), lexer.cursor());
                }
                lexer.next();
                if (index == null || left == null) {
                    return null;
                }
                return new ArrayAccessExpression(left, index);
            }
            case LPAREN: {
                current = lexer.next();
                ArrayList<Expression> arguments = new ArrayList<Expression>();
                if (current.kind() == TokenKind.EOF) {
                    throw new ParseException("Found EOF before closing RPAREN", lexer.cursor());
                }
                if (current.kind() == TokenKind.RPAREN) {
                    lexer.next();
                } else {
                    while (true) {
                        arguments.add(MolangParserImpl.parseCompoundExpression(lexer, 0));
                        current = lexer.current();
                        if (current.kind() == TokenKind.EOF) {
                            throw new ParseException("Found EOF before closing RPAREN", lexer.cursor());
                        }
                        if (current.kind() == TokenKind.RPAREN) {
                            lexer.next();
                            break;
                        }
                        if (current.kind() == TokenKind.ERROR) {
                            throw new ParseException("Found error token: " + current.value(), lexer.cursor());
                        }
                        if (current.kind() != TokenKind.COMMA) {
                            throw new ParseException("Expected a comma, got " + String.valueOf((Object)current.kind()), lexer.cursor());
                        }
                        lexer.next();
                    }
                }
                if (left == null) {
                    return null;
                }
                return new CallExpression(left, arguments);
            }
            case QUES: {
                int ternaryPrecedence = BinaryExpression.Op.CONDITIONAL.precedence();
                if (lastPrecedence >= ternaryPrecedence) {
                    return left;
                }
                lexer.next();
                Expression trueValue = MolangParserImpl.parseCompoundExpression(lexer, 0);
                if (lexer.current().kind() == TokenKind.COLON) {
                    lexer.next();
                    if (trueValue == null) {
                        return null;
                    }
                    Expression compoundExpression = MolangParserImpl.parseCompoundExpression(lexer, ternaryPrecedence);
                    if (compoundExpression == null || left == null) {
                        return null;
                    }
                    return new TernaryConditionalExpression(left, trueValue, compoundExpression);
                }
                if (trueValue == null || left == null) {
                    return null;
                }
                return new BinaryExpression(BinaryExpression.Op.CONDITIONAL, left, trueValue);
            }
        }
        switch (current.kind()) {
            case AMPAMP: {
                op = BinaryExpression.Op.AND;
                break;
            }
            case BARBAR: {
                op = BinaryExpression.Op.OR;
                break;
            }
            case LT: {
                op = BinaryExpression.Op.LT;
                break;
            }
            case LTE: {
                op = BinaryExpression.Op.LTE;
                break;
            }
            case GT: {
                op = BinaryExpression.Op.GT;
                break;
            }
            case GTE: {
                op = BinaryExpression.Op.GTE;
                break;
            }
            case PLUS: {
                op = BinaryExpression.Op.ADD;
                break;
            }
            case SUB: {
                op = BinaryExpression.Op.SUB;
                break;
            }
            case STAR: {
                op = BinaryExpression.Op.MUL;
                break;
            }
            case SLASH: {
                op = BinaryExpression.Op.DIV;
                break;
            }
            case QUESQUES: {
                op = BinaryExpression.Op.NULL_COALESCE;
                break;
            }
            case EQ: {
                op = BinaryExpression.Op.ASSIGN;
                break;
            }
            case EQEQ: {
                op = BinaryExpression.Op.EQ;
                break;
            }
            case BANGEQ: {
                op = BinaryExpression.Op.NEQ;
                break;
            }
            case ARROW: {
                op = BinaryExpression.Op.ARROW;
                break;
            }
            default: {
                return left;
            }
        }
        int precedence = op.precedence();
        if (lastPrecedence >= precedence) {
            return left;
        }
        lexer.next();
        Expression compoundExpression = MolangParserImpl.parseCompoundExpression(lexer, precedence);
        if (compoundExpression == null || left == null) {
            return null;
        }
        return new BinaryExpression(op, left, compoundExpression);
    }

    @Override
    @NotNull
    public MolangLexer lexer() {
        return this.lexer;
    }

    @Override
    @Nullable
    public Expression current() {
        if (this.current == UNSET_FLAG) {
            throw new IllegalStateException("No current parsed expression, call next() at least once!");
        }
        return (Expression)this.current;
    }

    @Override
    @Nullable
    public Expression next() throws IOException {
        Expression expr = this.next0();
        this.current = expr;
        return expr;
    }

    @Nullable
    private Expression next0() throws IOException {
        Token token = this.lexer.next();
        if (token.kind() == TokenKind.EOF) {
            return null;
        }
        if (token.kind() == TokenKind.ERROR) {
            throw new ParseException("Found an invalid token (error): " + token.value(), this.cursor());
        }
        Expression expression = MolangParserImpl.parseCompoundExpression(this.lexer, 0);
        token = this.lexer.current();
        if (token.kind() != TokenKind.EOF && token.kind() != TokenKind.SEMICOLON) {
            throw new ParseException("Expected a semicolon, but was " + String.valueOf(token), this.lexer.cursor());
        }
        return expression;
    }

    @Override
    public void close() throws IOException {
        this.lexer.close();
    }
}

